/**
* \file: cmdline_parser.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Rexaline Xavier  /  RexalineInfancia.Xavier@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include <stdio.h>
#include <string.h>
#include "util/cmdline_parser.h"
#include "util/helper.h"
#include "util/logger.h"

const cfg_cmd_line_spec_t init_level_cmdline_spec = {
		.cmd_arg_short	= INIT_LEVEL_CMD_SHORT,
		.cmd_arg_long	= INIT_LEVEL_CMD_LONG };

const cfg_cmd_line_spec_t state_path_cmdline_spec = {
		.cmd_arg_short	= STATE_PATH_CMD_SHORT,
		.cmd_arg_long	= STATE_PATH_CMD_LONG };

const cfg_cmd_line_spec_t script_root_cmdline_spec = {
		.cmd_arg_short	= SCRIPT_ROOT_CMD_SHORT,
		.cmd_arg_long 	= SCRIPT_ROOT_CMD_LONG };

const cfg_cmd_line_spec_t sysroot_cmdline_spec = {
		.cmd_arg_short 	= SYSROOT_CMD_SHORT,
		.cmd_arg_long 	= SYSROOT_CMD_LONG };

const cfg_cmd_line_spec_t sigdb_key_cmdline_spec = {
		.cmd_arg_short	= SIGDB_KEY_CMD_SHORT,
		.cmd_arg_long 	= SIGDB_KEY_CMD_LONG };

const cfg_cmd_line_spec_t sigdb_privkey_cmdline_spec = {
		.cmd_arg_short	= SIGDB_PRIVKEY_CMD_SHORT,
		.cmd_arg_long	= SIGDB_PRIVKEY_CMD_LONG };

const cfg_cmd_line_spec_t priv_key_dest_cmdline_spec = {
		.cmd_arg_short	= PRIVKEY_DEST_CMD_SHORT,
		.cmd_arg_long	= PRIVKEY_DEST_CMD_LONG };

const cfg_cmd_line_spec_t sig_db_cmdline_spec = {
		.cmd_arg_short	= SIG_DB_CMD_SHORT,
		.cmd_arg_long	= SIG_DB_CMD_LONG };

const cfg_cmd_line_spec_t levelnum_cmdline_spec = {
		.cmd_arg_short = LEVELNUM_CMD_SHORT,
		.cmd_arg_long  = LEVELNUM_CMD_LONG };

const cfg_cmd_line_spec_t levelprivkey_cmdline_spec = {
		.cmd_arg_short = LEVELPRIVKEY_CMD_SHORT,
		.cmd_arg_long  = LEVELPRIVKEY_CMD_LONG };

const cfg_cmd_line_spec_t serialnum_cmdline_spec = {
		.cmd_arg_short = SERIALNUM_CMD_SHORT,
		.cmd_arg_long  = SERIALNUM_CMD_LONG };

const cfg_cmd_line_spec_t ecuid_cmdline_spec = {
		.cmd_arg_short = ECUID_CMD_SHORT,
		.cmd_arg_long  = ECUID_CMD_LONG };

const cfg_cmd_line_spec_t conffile_cmdline_spec = {
		.cmd_arg_short 	= CONFFILE_CMD_SHORT,
		.cmd_arg_long 	= CONFFILE_CMD_LONG };

const cfg_cmd_line_spec_t help_cmdline_spec = {
		.cmd_arg_short 	= HELP_CMD_SHORT,
		.cmd_arg_long 	= HELP_CMD_LONG };

//--------------------------------------- cmdline parser support API's -------------------------------------------------
// check if long or short arg fits to key
static bool cmdline_parser_check_cmd_line_arg(cfg_item_t *item, const char *key)
{
	if (item->cmdline)
	{
		if (item->cmdline->cmd_arg_long)
		{
			if (strcmp(key, item->cmdline->cmd_arg_long) == 0)
				return true;
		}

		if (item->cmdline->cmd_arg_short)
		{
			if (strcmp(key, item->cmdline->cmd_arg_short) == 0)
				return true;
		}
	}

	return false;
}

static bool cmdline_parser_item_needs_value(const cfg_item_spec_t *spec)
{
	if (spec->kind == CFG_FLAG)
		return false;
	else
		return true;
}

static cfg_item_t *cmdline_parser_get_match_item(cfg_item_t *const items[],size_t items_count,
		const char *parse_val)
{
	size_t cfg_idx;
	cfg_item_t *item;

	for (cfg_idx = 0; cfg_idx < items_count; cfg_idx++)
	{
		item = items[cfg_idx];

		if (cmdline_parser_check_cmd_line_arg(item, parse_val))
			return item;
	}
	return NULL;
}

//----------------------------------------------------------------------------------------------------------------------

//--------------------------------------- global API's -----------------------------------------------------------------

error_code_t cmdline_parser_parse_cmd_line(cfg_item_t *const items[], size_t items_count,
		char *argv[], size_t argc)
{
	error_code_t result = RESULT_OK;
	size_t arg_cntr = 0;
	cfg_item_t *item;
	char *value = NULL;

	while (argc > arg_cntr)
	{
		item = cmdline_parser_get_match_item(items,items_count,argv[arg_cntr]);
		if (item != NULL)
		{
			if (cmdline_parser_item_needs_value(item->spec))
			{
				arg_cntr++;
				if (arg_cntr >= argc)
				{
					logger_log_error("Expected value after arguments %s or %s.",
							item->cmdline->cmd_arg_long,item->cmdline->cmd_arg_short);
					return RESULT_INVALID_ARGS;
				}
				value = argv[arg_cntr];
			}
			result = helper_item_set(item, value);
			if (result != RESULT_OK)
				return result;
		}
		else
			return RESULT_INVALID_ARGS;

		arg_cntr++; item = NULL; value = NULL;
	}
	return RESULT_OK;
}
//----------------------------------------------------------------------------------------------------------------------
